/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme.internal;

import com.aptana.core.util.PlatformUtil;
import com.aptana.theme.ColorManager;
import com.aptana.theme.IControlThemer;
import com.aptana.theme.IThemeManager;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;

class ControlThemer
implements IControlThemer {
    protected static final boolean isWindows = PlatformUtil.isWindows();
    protected static final boolean isMacOSX = PlatformUtil.isMac();
    protected static final boolean isCocoa = Platform.getWS().equals("cocoa");
    protected static final boolean isUbuntu = PlatformUtil.isOSName((String)"Ubuntu") || PlatformUtil.isOSName((String)"LinuxMint");
    private Control control;
    private Color defaultBg;
    private Listener selectionOverride;
    private IEclipsePreferences.IPreferenceChangeListener fThemeChangeListener;

    public ControlThemer(Control control) {
        this(control, null);
    }

    public ControlThemer(Control control, Color defaultBg) {
        this.control = control;
        this.defaultBg = defaultBg;
    }

    public void apply() {
        this.addThemeChangeListener();
        this.applyTheme();
    }

    protected void applyTheme() {
    }

    protected void applyControlColors() {
        this.getControl().setBackground(this.getBackground());
        this.getControl().setForeground(this.getForeground());
    }

    protected boolean controlIsDisposed() {
        Control control = this.getControl();
        if (control == null) {
            return true;
        }
        return control.isDisposed();
    }

    public void dispose() {
        this.unapplyTheme();
        this.removeThemeListener();
    }

    protected void unapplyTheme() {
        if (!this.controlIsDisposed()) {
            this.getControl().setRedraw(false);
            this.unapplyControlColors();
            this.getControl().setRedraw(true);
        }
    }

    protected void unapplyControlColors() {
        this.getControl().setBackground(this.defaultBg);
        this.getControl().setForeground(null);
    }

    protected Font getFont() {
        Font font = JFaceResources.getFont((String)"com.aptana.explorer.font");
        if (font == null) {
            font = JFaceResources.getTextFont();
        }
        return font;
    }

    protected Theme getCurrentTheme() {
        return this.getThemeManager().getCurrentTheme();
    }

    protected IThemeManager getThemeManager() {
        return ThemePlugin.getDefault().getThemeManager();
    }

    protected Color getBackground() {
        return this.getColorManager().getColor(this.getThemeManager().getCurrentTheme().getBackground());
    }

    protected Color getForeground() {
        return this.getColorManager().getColor(this.getThemeManager().getCurrentTheme().getForeground());
    }

    protected Color getSelection() {
        return this.getColorManager().getColor(this.getThemeManager().getCurrentTheme().getSelectionAgainstBG());
    }

    protected ColorManager getColorManager() {
        return ThemePlugin.getDefault().getColorManager();
    }

    protected Control getControl() {
        return this.control;
    }

    protected void addSelectionColorOverride() {
    }

    protected void removeSelectionOverride() {
        if (this.selectionOverride != null && !this.controlIsDisposed()) {
            this.getControl().removeListener(40, this.selectionOverride);
        }
        this.selectionOverride = null;
    }

    private void addThemeChangeListener() {
        this.fThemeChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (event.getKey().equals("THEME_CHANGED")) {
                    ControlThemer.this.applyTheme();
                }
            }
        };
        InstanceScope.INSTANCE.getNode("com.aptana.theme").addPreferenceChangeListener(this.fThemeChangeListener);
    }

    private void removeThemeListener() {
        if (this.fThemeChangeListener != null) {
            InstanceScope.INSTANCE.getNode("com.aptana.theme").removePreferenceChangeListener(this.fThemeChangeListener);
            this.fThemeChangeListener = null;
        }
    }
}

